/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cec;

import com.quantumdata.std.CECConstants;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CECGUIPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final String m_version = "1.1";
    private static final long serialVersionUID = 1L;
    JComboBox[] portAddr;
    JComboBox[] initAddr;
    JComboBox[] destAddr;
    JComboBox[] opcodes;
    JComboBox[] badBits;
    JTextField[] params;
    ButtonGroup selectedBitTiming;
    JRadioButton[] bitTimings;
    JTextField respField;
    JCheckBox[] nackModes;
    JCheckBox[] arbModes;
    JButton[] sendButtons;
    JButton respButton;
    ButtonGroup selectedPortList;
    JRadioButton[] portSelection;
    JPanel msgSubPanel;
    JPanel connectPanel;
    JPanel nackPanel;
    JPanel arbPanel;
    JPanel timingPanel;
    JPanel badBitPanel;
    JSlider slider;
    JTextField timingField;
    int currentAddr;
    int numMsgs;
    int[] timingValues;
    Font smallFont;
    Hashtable<Integer, JLabel> labelTable;
    RemoteInstrument m_instrument;
    public static final Dimension addrSize = new Dimension(85, 30);
    public static final Dimension opcodeSize = new Dimension(230, 30);
    public static final Dimension paramSize = new Dimension(130, 30);
    public static final Dimension modeSize = new Dimension(70, 30);
    public static final Dimension sliderSize = new Dimension(55, 120);
    public static final Dimension sendBtnSize = new Dimension(50, 30);

    public CECGUIPanel() {
        this.setSize(700, 480);
        this.setPreferredSize(new Dimension(700, 480));
        this.setBackground(Color.BLACK);
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_instrument = remoteInstrument;
    }

    public void disconnect() {
        if (this.m_instrument != null) {
            this.m_instrument.disconnect();
        }
    }

    public boolean create() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.timingValues = new int[6];
        this.smallFont = new Font("SansSerif", 0, 10);
        this.nackModes = new JCheckBox[4];
        this.arbModes = new JCheckBox[3];
        this.portAddr = new JComboBox[3];
        this.initAddr = new JComboBox[this.numMsgs];
        this.destAddr = new JComboBox[this.numMsgs];
        this.opcodes = new JComboBox[this.numMsgs];
        this.params = new JTextField[this.numMsgs];
        this.sendButtons = new JButton[this.numMsgs];
        this.badBits = new JComboBox[2];
        this.selectedPortList = new ButtonGroup();
        this.portSelection = new JRadioButton[3];
        this.respField = new JTextField();
        this.respButton = new JButton("Get Response");
        this.selectedBitTiming = new ButtonGroup();
        this.bitTimings = new JRadioButton[6];
        this.timingField = new JTextField();
        this.slider = new JSlider(1, 3500, 3900, 3700);
        this.msgSubPanel = new JPanel(gridBagLayout);
        this.connectPanel = new JPanel(gridBagLayout);
        this.nackPanel = new JPanel(gridBagLayout);
        this.arbPanel = new JPanel(gridBagLayout);
        this.timingPanel = new JPanel(gridBagLayout);
        this.badBitPanel = new JPanel(gridBagLayout);
        Color color = new Color(160, 160, 160);
        this.connectPanel.setBackground(color.brighter().brighter());
        Color color2 = color.darker();
        this.arbPanel.setBackground(color2);
        this.nackPanel.setBackground(color2);
        this.timingPanel.setBackground(color2);
        this.badBitPanel.setBackground(color2);
        this.msgSubPanel.setBackground(color);
        if (this.createConnectSubPanel(this.connectPanel)) {
            this.createMsgSubPanel(this.msgSubPanel);
            this.createNACKSubPanel(this.nackPanel);
            this.createArbitrationSubPanel(this.arbPanel);
            this.createTimingSubPanel(this.timingPanel);
            this.createBadBitSubPanel(this.badBitPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 6, 2, 6);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 11;
            this.add((Component)this.connectPanel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)this.arbPanel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridheight = 2;
            this.add((Component)this.nackPanel, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            this.add((Component)this.timingPanel, gridBagConstraints);
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(14, 6, 2, 6);
            this.add((Component)this.badBitPanel, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(2, 6, 2, 6);
            this.add((Component)this.msgSubPanel, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            return true;
        }
        this.add(this.connectPanel);
        return false;
    }

    private void createMsgSubPanel(JPanel jPanel) {
        jPanel.setBorder(new SoftBevelBorder(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Initiator:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel("Follower:"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)new JLabel("Opcode:"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)new JLabel("Parameters:"), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        JLabel jLabel = new JLabel("v1.1");
        jLabel.setForeground(Color.lightGray);
        jPanel.add((Component)jLabel, gridBagConstraints);
        for (int i = 0; i < this.numMsgs; ++i) {
            this.initAddr[i] = new JComboBox();
            this.destAddr[i] = new JComboBox();
            this.opcodes[i] = new JComboBox();
            this.params[i] = new JTextField();
            this.sendButtons[i] = new JButton("Send");
            this.sendButtons[i].setToolTipText("Sends the message in slot " + (i + 1) + ".");
            this.sendButtons[i].addActionListener(this);
            this.initAddr[i].setPreferredSize(addrSize);
            this.initAddr[i].setMinimumSize(addrSize);
            this.initAddr[i].setToolTipText("Sets the initiator address that will be sent in slot " + (i + 1) + "'s message.");
            this.destAddr[i].setPreferredSize(addrSize);
            this.destAddr[i].setMinimumSize(addrSize);
            this.destAddr[i].setToolTipText("Sets the follower address that will be sent in slot " + (i + 1) + "'s message.");
            this.opcodes[i].setPreferredSize(opcodeSize);
            this.opcodes[i].setMinimumSize(opcodeSize);
            this.opcodes[i].setToolTipText("Sets the opcode that will be sent in slot " + (i + 1) + "'s message.");
            this.opcodes[i].addActionListener(this);
            this.params[i].setPreferredSize(paramSize);
            this.params[i].setMinimumSize(paramSize);
            this.params[i].setToolTipText("<HTML>Enter parameters here<br> (in hex, with spaces between bytes).");
            this.sendButtons[i].setPreferredSize(sendBtnSize);
            this.sendButtons[i].setMinimumSize(sendBtnSize);
            for (int j = 0; j < 16; ++j) {
                this.initAddr[i].addItem("0x" + Integer.toHexString(j).toUpperCase() + ": " + CECConstants.getCECAddressName(j));
                this.destAddr[i].addItem("0x" + Integer.toHexString(j).toUpperCase() + ": " + CECConstants.getCECAddressName(j));
            }
            CECGUIPanel.addOpcodes(this.opcodes[i]);
            gridBagConstraints.gridy = i + 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.initAddr[i], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.destAddr[i], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.opcodes[i], gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.params[i], gridBagConstraints);
            gridBagConstraints.gridx = 4;
            jPanel.add((Component)this.sendButtons[i], gridBagConstraints);
        }
        gridBagConstraints.gridy = this.numMsgs + 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        this.respField.setPreferredSize(new Dimension(400, 30));
        this.respField.setMinimumSize(new Dimension(400, 30));
        this.respField.setEditable(false);
        this.respField.setToolTipText("The message received will appear here when ''Get Response'' is pressed.");
        jPanel.add((Component)this.respField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 2;
        this.respButton.setPreferredSize(addrSize);
        this.respButton.setMinimumSize(addrSize);
        this.respButton.setToolTipText("Gets the last message received on the selected HDMI port.");
        this.respButton.addActionListener(this);
        jPanel.add((Component)this.respButton, gridBagConstraints);
    }

    private boolean createConnectSubPanel(JPanel jPanel) {
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd("CECX:NCEC?");
        int n = 0;
        if (instrumentResponse.isError()) {
            this.reportError(instrumentResponse.getResponse());
            n = 0;
        } else {
            n = Integer.parseInt(instrumentResponse.getResponse());
        }
        if (n == 0) {
            Label label = new Label("The instrument does not support the CEC ITE feature.");
            label.setBackground(Color.BLACK);
            label.setForeground(Color.WHITE);
            jPanel.add(label);
            return false;
        }
        if (n > 3) {
            n = 3;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        TitledBorder titledBorder = new TitledBorder("Select Port & Configuration");
        titledBorder.setTitleJustification(2);
        jPanel.setBorder(titledBorder);
        gridBagConstraints.gridwidth = 1;
        this.portSelection[0] = new JRadioButton("OUT 1");
        this.portSelection[1] = new JRadioButton("OUT 2");
        this.portSelection[2] = new JRadioButton("IN 1 & 2");
        for (int i = 0; i < n; ++i) {
            this.portSelection[i].setFont(this.smallFont);
            this.portSelection[i].setBackground(jPanel.getBackground());
            this.portSelection[i].setToolTipText("Selects HDMI " + this.portSelection[i].getText() + " as the active CEC port.");
            gridBagConstraints.gridy = i + 1;
            this.portAddr[i] = new JComboBox();
            for (int j = 0; j < 16; ++j) {
                this.portAddr[i].addItem("0x" + Integer.toHexString(j).toUpperCase() + ": " + CECConstants.getCECAddressName(j));
            }
            this.setCurrentLA(i + 1, true);
            this.portAddr[i].setPreferredSize(addrSize);
            this.portAddr[i].setMinimumSize(addrSize);
            this.portAddr[i].setToolTipText("Selects the address associated with HDMI " + this.portSelection[i].getText() + ", if selected.");
            gridBagConstraints.gridx = 0;
            this.selectedPortList.add(this.portSelection[i]);
            this.portAddr[i].addActionListener(this);
            this.portSelection[i].addActionListener(this);
            this.portSelection[i].setPreferredSize(modeSize);
            jPanel.add((Component)this.portSelection[i], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.portAddr[i], gridBagConstraints);
        }
        return true;
    }

    private void createNACKSubPanel(JPanel jPanel) {
        jPanel.setBorder(new SoftBevelBorder(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        TitledBorder titledBorder = new TitledBorder("Enable ACKs");
        titledBorder.setTitleColor(Color.WHITE);
        jPanel.setBorder(titledBorder);
        for (int i = 0; i < 4; ++i) {
            gridBagConstraints.gridy = i + 1;
            this.nackModes[i] = new JCheckBox();
            this.nackModes[i].setSelected(true);
            String string = i < 2 ? "<HTML>Directed " : "<HTML>Broadcast ";
            string = i % 2 == 1 ? string + "<br>data" : string + "<br>header";
            this.nackModes[i].setText(string);
            this.nackModes[i].setFont(this.smallFont);
            this.nackModes[i].setForeground(Color.WHITE);
            this.nackModes[i].setToolTipText("<HTML>Sets whether or not incoming " + string.toLowerCase() + " bits are NACKed.</HTML>");
            this.nackModes[i].setPreferredSize(modeSize);
            this.nackModes[i].setMinimumSize(modeSize);
            this.nackModes[i].addActionListener(this);
            this.nackModes[i].setBackground(jPanel.getBackground());
            jPanel.add((Component)this.nackModes[i], gridBagConstraints);
        }
    }

    private void createArbitrationSubPanel(JPanel jPanel) {
        jPanel.setBorder(new SoftBevelBorder(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        for (int i = 0; i < 3; ++i) {
            this.arbModes[i] = new JCheckBox();
            this.arbModes[i].setPreferredSize(addrSize);
            this.arbModes[i].setMinimumSize(addrSize);
            this.arbModes[i].addActionListener(this);
            this.arbModes[i].setFont(this.smallFont);
            this.arbModes[i].setForeground(Color.WHITE);
            this.arbModes[i].setBackground(jPanel.getBackground());
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        TitledBorder titledBorder = new TitledBorder("Test Arbitration");
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleColor(Color.WHITE);
        jPanel.setBorder(titledBorder);
        gridBagConstraints.gridy = 1;
        this.arbModes[0].setText("<HTML>Seize start bit</HTML>");
        this.arbModes[0].setToolTipText("Holds the start bit low on the next incoming message. (once off)");
        jPanel.add((Component)this.arbModes[0], gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.arbModes[1].setText("<HTML>Seize address bits</HTML>");
        this.arbModes[1].setToolTipText("Sets all initiator address bits to 0 on the next incoming message. (once off)");
        jPanel.add((Component)this.arbModes[1], gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.arbModes[2].setText("<HTML>Seize data bits</HTML>");
        this.arbModes[2].setToolTipText("Sets an incoming data bit low on the next incoming message. (once off)");
        jPanel.add((Component)this.arbModes[2], gridBagConstraints);
    }

    private void resetTimingValues() {
        this.timingValues[0] = 3700;
        this.timingValues[1] = 4500;
        this.timingValues[2] = 600;
        this.timingValues[3] = 2400;
        this.timingValues[4] = 1500;
        this.timingValues[5] = 2400;
    }

    private void createTimingSubPanel(JPanel jPanel) {
        JLabel jLabel;
        int n;
        this.resetTimingValues();
        jPanel.setBorder(new SoftBevelBorder(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = new String[]{"<HTML>Start bit low period (3.5-3.9ms)</HTML>", "<HTML>Start bit total period (4.3-4.7ms)</HTML>", "<HTML>1 bit low period (0.4-0.8ms)</HTML>", "<HTML>1 bit total period (2.05-2.75ms)</HTML>", "<HTML>0 bit low period (1.3-1.7ms)</HTML>", "<HTML>0 bit total period (2.05-2.75ms)</HTML>"};
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        TitledBorder titledBorder = new TitledBorder("Control Timing");
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleColor(Color.WHITE);
        jPanel.setBorder(titledBorder);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        for (n = 0; n < 6; ++n) {
            this.bitTimings[n] = new JRadioButton();
            this.bitTimings[n].addActionListener(this);
            this.bitTimings[n].setToolTipText("<HTML>Select " + stringArray[n].toLowerCase());
            this.selectedBitTiming.add(this.bitTimings[n]);
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.gridx = 0;
            jLabel = new JLabel(stringArray[n], 4);
            jLabel.setMinimumSize(paramSize);
            jLabel.setPreferredSize(paramSize);
            jLabel.setFont(this.smallFont);
            jLabel.setForeground(Color.WHITE);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.bitTimings[n].setBackground(jPanel.getBackground());
            jPanel.add((Component)this.bitTimings[n], gridBagConstraints);
        }
        this.bitTimings[0].setSelected(true);
        this.labelTable = new Hashtable();
        Integer[] integerArray = new Integer[]{420, 600, 780, 1320, 1500, 1680, 2070, 2400, 2730, 3520, 3700, 3880, 4320, 4500, 4680};
        for (n = 0; n < 15; ++n) {
            jLabel = new JLabel((double)integerArray[n].intValue() / 1000.0 + "ms");
            jLabel.setFont(this.smallFont);
            jLabel.setForeground(Color.WHITE);
            this.labelTable.put(integerArray[n], jLabel);
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.timingField.setMinimumSize(modeSize);
        this.timingField.setPreferredSize(modeSize);
        this.timingField.addActionListener(this);
        jPanel.add((Component)this.timingField, gridBagConstraints);
        this.setupSlider(this.slider, this.labelTable);
        this.timingField.setText("" + (double)this.slider.getValue() / 1000.0);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.slider, gridBagConstraints);
    }

    private void setupSlider(JSlider jSlider, Hashtable<Integer, JLabel> hashtable) {
        jSlider.setMajorTickSpacing(90);
        jSlider.setPaintTicks(true);
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintLabels(true);
        jSlider.setMinimumSize(sliderSize);
        jSlider.setPreferredSize(sliderSize);
        jSlider.setFont(this.smallFont);
        jSlider.addChangeListener(this);
        jSlider.setBackground(this.timingPanel.getBackground());
        jSlider.setForeground(Color.WHITE);
    }

    private void createBadBitSubPanel(JPanel jPanel) {
        int n;
        jPanel.setBorder(new SoftBevelBorder(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 7, 0, 8);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        TitledBorder titledBorder = new TitledBorder("Corrupt");
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleColor(Color.WHITE);
        jPanel.setBorder(titledBorder);
        this.badBits[0] = new JComboBox();
        this.badBits[0].addActionListener(this);
        this.badBits[0].setToolTipText("Selects which byte will be corrupted.");
        for (n = 0; n < 16; ++n) {
            this.badBits[0].addItem("Byte " + (n + 1));
        }
        this.badBits[1] = new JComboBox();
        this.badBits[1].addActionListener(this);
        this.badBits[1].setToolTipText("Selects which bits in the selected byte will be corrupted (if any).");
        this.badBits[1].addItem("No bits of");
        for (n = 0; n < 8; ++n) {
            this.badBits[1].addItem("Bit " + (n + 1) + " of");
        }
        this.badBits[0].setMinimumSize(addrSize);
        this.badBits[1].setMinimumSize(addrSize);
        this.badBits[0].setPreferredSize(addrSize);
        this.badBits[1].setPreferredSize(addrSize);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.badBits[1], gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.badBits[0], gridBagConstraints);
    }

    public static void addOpcodes(JComboBox jComboBox) {
        String string = "0";
        jComboBox.addItem("Select an opcode...");
        for (int i = 0; i < 256; ++i) {
            if (i > 15) {
                string = "";
            }
            if (!CECConstants.isLegalOpcode(i)) continue;
            jComboBox.addItem("0x" + string + Integer.toHexString(i).toUpperCase() + ": " + CECConstants.getCECOpcodeName(i));
        }
        jComboBox.addItem("      Polling Message");
    }

    private String getMsgString(int n) {
        String string = this.getPortString();
        if (string.length() == 0) {
            this.reportError("Please select a port.");
            return "";
        }
        string = string + ":MSGX " + this.initAddr[n].getSelectedIndex();
        string = string + " " + this.destAddr[n].getSelectedIndex();
        String string2 = this.opcodes[n].getItemAt(this.opcodes[n].getSelectedIndex()).toString().substring(2, 4);
        if (this.opcodes[n].getSelectedIndex() == 0) {
            this.reportError("Please select an opcode.");
            return "";
        }
        string = string + " " + string2;
        string = string + " " + this.params[n].getText();
        return string;
    }

    private String getPortString() {
        int n = this.getSelectedPort();
        if (n > 0) {
            return "CEC" + n;
        }
        return "";
    }

    private String getArbitrationModesString() {
        String string = this.getPortString();
        if (string.length() == 0) {
            return "";
        }
        string = string + ":CECT:ARBM";
        for (int i = 0; i < 3; ++i) {
            string = this.arbModes[i].isSelected() ? string + " 1" : string + " 0";
        }
        return string;
    }

    private String getNACKModesString() {
        String string = this.getPortString();
        if (string.length() == 0) {
            return "";
        }
        string = string + ":CECT:NACK";
        for (int i = 0; i < 4; ++i) {
            string = this.nackModes[i].isSelected() ? string + " 0" : string + " 1";
        }
        return string;
    }

    private void sendBadBitsString() {
        String string = this.getPortString();
        if (string.length() == 0) {
            return;
        }
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(string + ":CECT:BADS " + this.badBits[0].getSelectedIndex());
        if (instrumentResponse.isError()) {
            this.reportError(instrumentResponse.getResponse());
        }
        string = string + ":CECT:BADM ";
        int n = this.badBits[1].getSelectedIndex();
        if (n == 0) {
            string = string + "0";
        } else {
            n = 8 - n;
            n = 1 << n;
            string = string + Integer.toHexString(n);
        }
        instrumentResponse = this.m_instrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            this.reportError(instrumentResponse.getResponse());
        }
    }

    public void initializeAddress() {
        InstrumentResponse instrumentResponse;
        int n;
        this.resetTimingValues();
        for (n = 0; n < 6; ++n) {
            if (!this.bitTimings[n].isSelected()) continue;
            this.slider.setValue(this.timingValues[n]);
        }
        n = this.getSelectedPort();
        if (n == 0) {
            return;
        }
        String string = "CEC" + n;
        String string2 = Integer.toString(this.currentAddr);
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if ((instrumentResponse = this.m_instrument.sendCmd(string + ":CECL CECDev" + string2)).isError()) {
            this.reportError(instrumentResponse.getResponse());
        }
        if ((instrumentResponse = this.m_instrument.sendCmd(string + ":CECU")).isError()) {
            this.reportError(instrumentResponse.getResponse());
        }
        if ((instrumentResponse = this.m_instrument.sendCmd(string + ":BUSM:ON")).isError()) {
            this.reportError(instrumentResponse.getResponse());
        }
        for (int i = 0; i < this.numMsgs; ++i) {
            this.initAddr[i].setSelectedIndex(this.currentAddr);
        }
        instrumentResponse = this.m_instrument.sendCmd(this.getArbitrationModesString());
        if (instrumentResponse.isError()) {
            this.reportError(instrumentResponse.getResponse());
        }
        if ((instrumentResponse = this.m_instrument.sendCmd(this.getNACKModesString())).isError()) {
            this.reportError(instrumentResponse.getResponse());
        }
        this.sendBadBitsString();
        this.setCurrentLA(n, false);
    }

    private int getSelectedPort() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.portSelection[i].isSelected()) continue;
            n = i + 1;
            this.currentAddr = this.portAddr[i].getSelectedIndex();
        }
        return n;
    }

    private void setCurrentLA(int n, boolean bl) {
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd("CEC" + n + ":LA?");
        int n2 = Integer.parseInt(instrumentResponse.getResponse());
        if (n2 == -1) {
            n2 = 15;
        }
        if (this.portAddr[n - 1].getSelectedIndex() != n2 & !bl) {
            JOptionPane.showMessageDialog(this, "Address already taken, taking address " + n2, "Warning", 1);
        }
        this.portAddr[n - 1].setSelectedIndex(n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object;
        Object object2 = actionEvent.getSource();
        if (object2 == this.respButton) {
            String string = this.getPortString();
            if (string.length() == 0) {
                this.reportError("Please select a port.");
                return;
            }
            InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(string + ":MSGX?");
            this.respField.setText(instrumentResponse.getResponse());
            return;
        }
        if (object2 == this.timingField) {
            object = this.timingField.getText();
            try {
                this.slider.setValue((int)(Double.parseDouble((String)object) * 1000.0));
            }
            catch (Exception exception) {
                this.reportError("Invalid input!");
            }
        }
        for (n = 0; n < this.numMsgs; ++n) {
            if (object2 == this.sendButtons[n]) {
                object = this.getMsgString(n);
                if (((String)object).length() == 0) {
                    return;
                }
                InstrumentResponse instrumentResponse = this.m_instrument.sendCmd((String)object);
                for (int i = 0; i < 3; ++i) {
                    this.arbModes[i].setSelected(false);
                }
                if (instrumentResponse.isError()) {
                    this.reportError(instrumentResponse.getResponse());
                }
                return;
            }
            if (object2 != this.opcodes[n]) continue;
            object = this.opcodes[n].getItemAt(this.opcodes[n].getSelectedIndex()).toString().substring(2, 4);
            if (((String)object).equalsIgnoreCase("le") || ((String)object).trim().length() == 0) {
                return;
            }
            int n2 = Integer.valueOf((String)object, 16);
            this.params[n].setToolTipText(this.getParamText(n2));
            if (!CECConstants.isDirected(n2)) {
                this.destAddr[n].setSelectedIndex(15);
            } else if (!CECConstants.isBroadcast(n2) && this.destAddr[n].getSelectedIndex() == 15) {
                if (this.initAddr[n].getSelectedIndex() != 0) {
                    this.destAddr[n].setSelectedIndex(0);
                } else {
                    this.destAddr[n].setSelectedIndex(1);
                }
            }
            return;
        }
        for (n = 0; n < 2; ++n) {
            if (object2 != this.badBits[n]) continue;
            this.sendBadBitsString();
            return;
        }
        for (n = 0; n < 3; ++n) {
            if (object2 == this.portSelection[n]) {
                this.initializeAddress();
                return;
            }
            if (object2 == this.portAddr[n]) {
                if (this.portSelection[n].isSelected()) {
                    int n3 = this.currentAddr;
                    String string = this.getPortString();
                    if (string.length() == 0) {
                        return;
                    }
                    if (n3 != this.currentAddr) {
                        this.initializeAddress();
                    }
                }
                return;
            }
            if (object2 != this.arbModes[n]) continue;
            object = this.getArbitrationModesString();
            if (((String)object).length() == 0) {
                return;
            }
            InstrumentResponse instrumentResponse = this.m_instrument.sendCmd((String)object);
            if (instrumentResponse.isError()) {
                this.reportError(instrumentResponse.getResponse());
            }
            return;
        }
        for (n = 0; n < 4; ++n) {
            if (object2 != this.nackModes[n]) continue;
            object = this.getNACKModesString();
            if (((String)object).length() == 0) {
                return;
            }
            InstrumentResponse instrumentResponse = this.m_instrument.sendCmd((String)object);
            if (instrumentResponse.isError()) {
                this.reportError(instrumentResponse.getResponse());
            }
            return;
        }
        for (n = 0; n < 6; ++n) {
            if (object2 != this.bitTimings[n]) continue;
            if (this.bitTimings[n].isSelected()) {
                this.timingPanel.remove(this.slider);
                this.timingField.setText("" + (double)this.timingValues[n] / 1000.0);
                this.slider = this.timingValues[n] >= 420 && this.timingValues[n] <= 780 ? new JSlider(1, 420, 780, this.timingValues[n]) : (this.timingValues[n] >= 1320 && this.timingValues[n] <= 1680 ? new JSlider(1, 1320, 1680, this.timingValues[n]) : (this.timingValues[n] >= 2070 && this.timingValues[n] <= 2730 ? new JSlider(1, 2070, 2730, this.timingValues[n]) : (this.timingValues[n] >= 3520 && this.timingValues[n] <= 3880 ? new JSlider(1, 3520, 3880, this.timingValues[n]) : new JSlider(1, 4320, 4680, this.timingValues[n]))));
                this.setupSlider(this.slider, this.labelTable);
                object = new GridBagConstraints();
                ((GridBagConstraints)object).insets = new Insets(2, 2, 0, 2);
                ((GridBagConstraints)object).gridheight = 0;
                ((GridBagConstraints)object).gridx = 2;
                ((GridBagConstraints)object).gridy = 2;
                this.timingPanel.add((Component)this.slider, object);
                this.timingPanel.updateUI();
            }
            return;
        }
    }

    public void reportError(String string) {
        JOptionPane.showMessageDialog(this, string, "Error!", 0);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider == this.slider) {
                int n = 0;
                for (int i = 0; i < 6; ++i) {
                    if (!this.bitTimings[i].isSelected()) continue;
                    n = i;
                    this.timingValues[i] = this.slider.getValue();
                }
                this.timingField.setText("" + (double)this.timingValues[n] / 1000.0);
                if (!jSlider.getValueIsAdjusting()) {
                    String string = this.getPortString();
                    if (string.length() == 0) {
                        return;
                    }
                    string = string + ":CECT:";
                    string = (n /= 2) == 0 ? string + "SBIT " : (n == 1 ? string + "1BIT " : string + "0BIT ");
                    InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(string = string + (double)this.timingValues[2 * n] / 1000.0 + " " + (double)this.timingValues[2 * n + 1] / 1000.0);
                    if (instrumentResponse.isError()) {
                        this.reportError(instrumentResponse.getResponse());
                    }
                }
            }
        } else {
            return;
        }
    }

    private String getParamText(int n) {
        switch (n) {
            case 129: 
            case 130: 
            case 134: 
            case 157: {
                return "Physical Address (2 bytes)";
            }
            case 112: {
                return "(Optional) Physical Address (2 bytes)";
            }
            case 128: {
                return "Old Physical Address (2 bytes), New Physical Address (2 bytes)";
            }
            case 9: {
                return "Record Source (1-8 bytes, depending on source)";
            }
            case 10: {
                return "Record Status (1 byte)";
            }
            case 132: {
                return "Physical Address (2 bytes), Device Type (1 byte)";
            }
            case 50: {
                return "Language (3 bytes)";
            }
            case 66: {
                return "Deck Control Mode (1 byte)";
            }
            case 27: {
                return "Deck Status (1 byte)";
            }
            case 8: 
            case 26: {
                return "Status Request (1 byte)";
            }
            case 65: {
                return "Play Mode (1 byte)";
            }
            case 146: {
                return "<HTML>Analogue Broadcast Type (1 byte),<br>Analogue Frequency (2 bytes),<br>Broadcast System (1 byte)";
            }
            case 147: {
                return "Digital Service Identification (7 bytes)";
            }
            case 7: {
                return "Tuner Device Info (1 byte), Analogue or Digital Service ID (4-7 bytes)";
            }
            case 135: 
            case 160: {
                return "Device Vendor ID (3 bytes)";
            }
            case 137: 
            case 138: {
                return "Vendor Specific data - up to 14 bytes";
            }
            case 100: {
                return "Display Control (1 byte), OSD String (up to 13 bytes)";
            }
            case 71: {
                return "OSD Name (up to 8 bytes)";
            }
            case 141: {
                return "Menu Request Type (1 byte)";
            }
            case 142: {
                return "Menu State (1 byte)";
            }
            case 68: {
                return "UI Command (1 byte)";
            }
            case 144: {
                return "Power Status (1 byte)";
            }
            case 0: {
                return "Feature Opcode (1 byte), Abort Reason (1 byte)";
            }
            case 158: {
                return "CEC Version (1 byte)";
            }
            case 103: {
                return "Program Title (up to 14 bytes)";
            }
            case 51: 
            case 52: {
                return "<HTML>Start Date (2 bytes),<br>Start Time (2 bytes),<br>Duration (2 bytes),<br>Recording Sequence (1 byte),<br>Analogue Broadcast Type (1 byte),<br>Analogue Frequency (2 bytes),<br>Broadcast System (1 byte)";
            }
            case 151: 
            case 153: {
                return "<HTML>Start Date (2 bytes),<br>Start Time (2 bytes),<br>Duration (2 bytes),<br>Recording Sequence (1 byte),<br>Digital Service Identification (7 bytes)";
            }
            case 161: 
            case 162: {
                return "<HTML>Start Date (2 bytes),<br>Start Time (2 bytes),<br>Duration (2 bytes),<br>Recording Sequence (1 byte),<br>External Source Specifier (2-3 bytes)";
            }
            case 67: {
                return "Timer Cleared Status (1 byte)";
            }
            case 122: {
                return "Audio Status (1 byte)";
            }
            case 114: 
            case 126: {
                return "System Audio Status (1 byte)";
            }
            case 154: {
                return "Audio Rate (1 byte)";
            }
            case 53: {
                return "Timer Status Data (1 byte), (Optional) Duration (2 bytes)";
            }
        }
        return "No parameters.";
    }
}

